/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.pim;

import java.util.Enumeration;
import java.util.Hashtable;

public class PimField {
    String name;
    Object value;
    Hashtable properties;

    public PimField(PimField orig) {
        this(orig.name);
        if (orig.value instanceof String[]) {
            String[] val = new String[((String[])orig.value).length];
            System.arraycopy((String[])orig.value, 0, val, 0, val.length);
            this.value = val;
        } else {
            this.value = orig.value;
        }
        if (orig.properties != null) {
            this.properties = new Hashtable();
            Enumeration e = orig.properties.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.properties.put(name, orig.properties.get(name));
            }
        }
    }

    public PimField(String name) {
        this.name = name;
    }

    public Enumeration propertyNames() {
        return this.properties.keys();
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            if (value == null) {
                return;
            }
            this.properties = new Hashtable();
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.name + (this.properties != null ? ";" + this.properties : "") + ":" + this.value;
    }

    public String getProperty(String name) {
        return this.properties == null ? null : (String)this.properties.get(name);
    }

    public boolean getAttribute(String name) {
        String s = this.getProperty("type");
        return s == null ? false : s.indexOf(name) != -1;
    }

    public void setAttribute(String name, boolean value) {
        if (this.getAttribute(name) == value) {
            return;
        }
        String s = this.getProperty("type");
        if (value) {
            s = s == null || s.length() == 0 ? name : s + name;
        } else {
            int i = s.indexOf(name);
            if (i > 0) {
                --i;
            }
            if (i != -1) {
                s = s.substring(0, i) + s.substring(i + name.length() + 1);
            }
        }
        this.setProperty("type", s);
    }
}

